// Selection +.js
//

// v.20090618 fix seletion function.

Vec3D.prototype.dot = function( p) {
	return this.x * p.x + this.y * p.y + this.z * p.z;
}
Vec3D.prototype.cross = function( p) {
	return new Vec3D(this.y * p.z - this.z * p.y, this.x * p.z - this.z * p.x,this.x * p.y - this.y * p.x);
}
Vec3D.prototype.length = function() {
	return  Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
}
Vec3D.prototype.normalize = function() {
	var l = this.norm();
	return (l < 0.0001 /* == 0 */ ) ? new Vec3D() : this.multiply(1/l);
}
Vec3D.prototype.toString = function() {
	return "(" + this.x.toFixed(4) + ", " + this.y.toFixed(4) + ", " + this.z.toFixed(4) + ")";
}
//
function Edge(p1, p2, v1, v2) {
	this.p1 = p1;
	this.p2 = p2;
	//
	this.v1 = v1;
	this.v2 = v2;
}
Edge.prototype.toString = function() {
	return '(e) p1:'+this.p1+' p2:'+this.p2+' v1:'+this.v1+' v2:'+this.v2+'/';
}
//
Array.prototype.pushEdge = function(p, v1, v2) {
	var isPushed = false;
	var len = this.length;
	for (var i = 0;i < len;i++) {
		if ( (this[i].v1 == v1 && this[i].v2 == v2) || (this[i].v2 == v1 && this[i].v1 == v2) ) {
			isPushed = true;
			if (this[i].p2 == null) {
				this[i].p2 = p;
			}
		}
	}
	if (isPushed == false) {
		this.push( new Edge(p, null, v1, v2) );
	}
}
//
function buildUI(tool) {
	tool.addParameterSeparator("Normal Polygons");
	tool.addParameterFloat("tolerance angle", 0.5, 0, 180, false, false);
	tool.addParameterBool("side-by-side", 0, 0, 1, false, false);
	tool.addParameterButton("same normal", "select", "selectSameNormal");
	
	tool.addParameterSeparator("Open Edges");
	tool.addParameterButton("open edges", "select", "selectOpenEdges");
	
	tool.addParameterSeparator("Cover Edges");
	tool.addParameterButton("cover edges", "select", "selectCoverEdges");
}

function selectSameNormal(tool) {
	var obj = tool.document().selectedObject();
	var tol = tool.getParameter("tolerance angle");
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	if (tool.document().editMode() != POLY_MODE) {
		OS.beep();
		return;
	}
	var c_tol = 1 - (tol*Math.PI/180);
	
	var core = obj.core();
	var count = core.polygonCount();
	var sel_idx = null;
	var sel_norm = null;
	var sels = [];
	var p_sels = [];
	var i, j, k;
	
	for (i = count - 1; i >= 0; i--) {
		if (core.polygonSelection(i)) {
			var normal = core.normal(i);
			p_sels.push(i);
			
			for (j = count - 1;j >= 0;j--) {
				if (i != j) {
					var b_normal = core.normal(j);
					
					//print(i+':'+j+':dot'+normal.dot(b_normal).toFixed(2)+':corss-'+normal.cross(b_normal));
					if (normal.dot(b_normal) >= c_tol ) {
						sels.push(j);
					}
				}
			}
		}
	}
	
	if (tool.getParameter("side-by-side")) {
		var v1, v2;
		var vecs = [];
		var p_count = p_sels.length;
		var pi, size = 0;
		for (i = 0; i < p_count;i++) {
			pi = p_sels[i];
			size = core.polygonSize(pi);
			for (j = 0;j < size;j++) {
				v1 = core.vertexIndex(pi, j);
				v2 = core.vertexIndex(pi, (j == size - 1)? 0 : j+1);
				vecs.push( [v1, v2] );
			}
		}
		var sel;
		var vlen = vecs.length;
		var len = sels.length;
		for (i = 0;i < len;i++) {
			sel = false
			pi = sels[i];
			size = core.polygonSize( pi );
			if ( core.polygonSelection(pi) ) {
				;
			} else {
				for (j = 0;j < size;j++) {
					v1 = core.vertexIndex(pi, j);
					v2 = core.vertexIndex(pi, (j == size - 1)? 0 : j+1);
					
					for (k = 0;k < vlen;k++) {
						if ( (vecs[k][0] == v1 && vecs[k][1] == v2) || 
								(vecs[k][1] == v1 && vecs[k][0] == v2) ) {
							sel = true;
						}
					}
				}
				if (sel) {
					core.setPolygonSelection(pi, true);
				}
			}
		}
	} else {
		var len = sels.length;
		for (i = 0;i < len;i++) {
			core.setPolygonSelection(sels[i], true);
		}
	}
	obj.update();
}

function selectOpenEdges(tool) {
	var obj = tool.document().selectedObject();
	
	if (! obj || obj.family() != NGONFAMILY) {
		OS.beep();
		return;
	}
	
	if (tool.document().editMode() != EDGE_MODE) {
		OS.beep();
		return;
	}
	
	var sels = [];
	var edges = [];
	var core = obj.core();
	var count = core.polygonCount();
	var size, i, j, k;
	
	for (i = 0;i < count;i++) {
		size = core.polygonSize(i);
		for (j = 0;j < size;j++) {
			v1 = core.vertexIndex(i, j);
			v2 = core.vertexIndex(i, (j == size-1)? 0 : j+1 );
			if (core.edgeSelection(i, j, SELECT)) {
				sels.pushEdge(i, v1, v2);
			} else {
				edges.pushEdge(i, v1, v2);
			}
		}
	}
	//
	var v_list = [];
	var len = sels.length;
	for (i = 0;i < len;i++) {
		var edge = sels[i];
		var v1_ins = true;
		var v2_ins = true;
		var vlen = v_list.length;
		for (j = 0;j < vlen;j++) {
			if (v_list[j][0] == edge.v1) {
				v1_ins = false;
				v_list[j][1] += 1;
			}
			if (v_list[j][0] == edge.v2) {
				v2_ins = false;
				v_list[j][1] += 1;
			}
		}
		if (v1_ins) v_list.push([edge.v1, 1]);
		if (v2_ins) v_list.push([edge.v2, 1]);
	}
	
	edges_new = [];
	for (i = edges.length - 1;i >= 0;i--) { // only open edge.
		if (edges[i].p2 == null) {
			edges_new.push( edges[i] );
		}
	}
	
	var loop_count = 0;
	var loop = true;
	while (loop && edges_new.length > 0) {
		var elen = edges_new.length;
		for (i = 0;i < elen;i++) {
			var vlen = v_list.length;
			var edge = edges_new[i];
			var insert_edge = false;
			for (j = 0;j < vlen;j++) {
				var insert_edge = false;
				if (v_list[j][1] == 1) {
					if (v_list[j][0] == edge.v1) {
						size = core.polygonSize(edge.p1);
						for (k = 0;k < size;k++) {
							if (edge.v1 == core.vertexIndex(edge.p1, k)) {
								core.setEdgeSelection(edge.p1, k, SELECT, true);
								core.setEdgeSelection(edge.p1, k, UVEDGE, true);
								v_list[j][1] += 1;
								insert_edge = edge.v2;
								break;
							}
						}
					} else if (v_list[j][0] == edge.v2) {
						size = core.polygonSize(edge.p1);
						for (k = 0;k < size;k++) {
							if (edge.v2 == core.vertexIndex(edge.p1, k)) {
								if (k == 0) {
									core.setEdgeSelection(edge.p1, size - 1, SELECT, true);
									core.setEdgeSelection(edge.p1, size - 1, UVEDGE, true);
								} else {
									core.setEdgeSelection(edge.p1, k-1, SELECT, true);
									core.setEdgeSelection(edge.p1, k-1, UVEDGE, true);
								}
								v_list[j][1] += 1;
								insert_edge = edge.v1;
								break;
							}
						}
					}
				}
				if (insert_edge != false) {
					var insert = true;
					for (k = 0;k < vlen;k++) {
						if (v_list[k][0] == insert_edge) {
							insert = false;
							v_list[k][1] += 1;
						}
					}
					if (insert) {
						v_list.push( [ insert_edge, 1 ] );
					}
				}
			}
		}
		// check
		loop = false;
		for (i = 0;i < v_list.length;i++) {
			if (v_list[i][1] == 1) {
				loop = true;
			}
		}
		if (loop_count++ > 1000) loop = false;
		//
		
	}
	obj.update();
}

function selectCoverEdges(tool) {
	var obj = tool.document().selectedObject();
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	if (tool.document().editMode() != EDGE_MODE) {
		OS.beep();
		return;
	}
	
	var core = obj.core();
	var count = core.polygonCount();
	var size = 0;
	var sels = [];
	var insert = false;
	var len = 0;
	var i,j,k;
	
	for (i = 0; i < count; i++) {
		size = core.polygonSize(i);
		for (j = 0;j < size;j++) {
			if (core.edgeSelection(i, j, SELECT)) {
				insert = true;
				len = sels.length;
				for (k = 0;k < len;k++) {
					if (sels[k][0] == i) {
						insert = false;
						sels[k][1] += 1;
					}
				}
				if (insert) {
					sels.push( [i, 1] );
				}
			}
		}
	}
	
	var vecs = [];
	var v1, v2, pi;
	len = sels.length;
	for (i = 0; i < len;i++) {
		if (sels[i][1] > 1) {
			pi = sels[i][0];
			size = core.polygonSize( pi );
			
			for (j = 0;j < size;j++) {
				core.setEdgeSelection( sels[i][0], j, SELECT, true );
				core.setEdgeSelection( sels[i][0], j, UVEDGE, true );
				
				v1 = core.vertexIndex( pi, j  );
				v2 = core.vertexIndex( pi, (j == size-1)? 0 : j+1 );
				vecs.push( [v1, v2] );
			}
		}
	}
	
	var v_len = vecs.length;
	len = core.polygonCount();
	for (i = 0;i < len;i++) {
		size = core.polygonSize( i );
		for (j = 0;j < size;j++) {
			v1 = core.vertexIndex(i,j);
			v2 = core.vertexIndex(i, (j == size-1)? 0 : j+1 );
			for (k = 0;k < v_len;k++) {
				if (( v1 == vecs[k][0] && v2 == vecs[k][1] )) {
					core.setEdgeSelection(i, j, SELECT, true);
					core.setEdgeSelection(i, j, UVEDGE, true);
				} else if ((v1 == vecs[k][1] && v2 == vecs[k][0])) {
					core.setEdgeSelection(i, j, SELECT, true);
					core.setEdgeSelection(i, j, UVEDGE, true);
				}
			}
		}
	}
	
	obj.update();
}
